package de.fzi.wim.trie.extractor.syntax;

import java.util.HashMap;

/**
 * A class for tokens representing some syntactical elements of the language.
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class SyntaxToken implements java.io.Serializable{

    public static final SyntaxToken punctuation = new SyntaxToken("Punctuation");
    private static final char[] punctuationChars = {'.',';',',',':'};

    public static final SyntaxToken number = new SyntaxToken("Number");
    private static final char[] numberChars = {'0','1','2','3','4','5','6','7','8','9'};

    public static final SyntaxToken lineBreak = new SyntaxToken("Line Break");
    private static final char[] lineBreakChars = {'\n'};

    public static final SyntaxToken space = new SyntaxToken("Space");
    private static final char[] spaceChars = {' '};

    public static final SyntaxToken special = new SyntaxToken("Special Character");
    public static final SyntaxToken begin = new SyntaxToken("Begin");
    public static final SyntaxToken end = new SyntaxToken("End");
    public static final SyntaxToken eos = new SyntaxToken("End of Sentence");

    public static HashMap tokenForCharacter = new HashMap();

    static {
        fillTokenForCharacter(punctuation,punctuationChars);
        fillTokenForCharacter(number,numberChars);
        fillTokenForCharacter(lineBreak,lineBreakChars);
        fillTokenForCharacter(space,spaceChars);
    }

    private static void fillTokenForCharacter(SyntaxToken token, char[] character) {
        for (int i=0;i<character.length;i++) {
            tokenForCharacter.put(new Character(character[i]),token);
        }
    }

    private String name;

     SyntaxToken (String name) {
        this.name = name;
    }

    public String toString() {
        return "Syntax token: "+name;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof SyntaxToken) {
            return name.equals(((SyntaxToken)other).name);
        }
        else {
            return false;
        }
    }

}
