package de.fzi.wim.trie.extractor.character;

import java.util.Vector;
import de.fzi.wim.trie.extractor.*;

/**
 * Accepts Whitespace characters.
 *
 * @author <a href="zach@fzo.de">Valentin Zacharias</a>
 */
public class WhitespaceCharacterTokenTemplate implements TokenTemplate, java.io.Serializable {

    public Object clone() {
        return new WhitespaceCharacterTokenTemplate();
    }

    public boolean satisfied(TokenSet tokenSet,Pointer pointer) {
        Vector temp = tokenSet.getBeginningTokens();
        for (int i=0;i<temp.size();i++) {
            if (temp.elementAt(i) instanceof CharacterToken) {
                if (((CharacterToken) temp.elementAt(i)).isWhitespace()) return true;
            }
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof WhitespaceCharacterTokenTemplate) return true;
        else return false;
    }

}
