package de.fzi.wim.trie.extractor.character;

import de.fzi.wim.trie.extractor.*;
import java.util.Vector;

/**
 * The same like as the AnyCharacterTokenTemplate BUT it saves
 * the characters it encounters in the pointer hashMap and it does not
 * decrease pointer confidence.
 *
 * @see AnyCharacterTokenTemplate
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class SavingAnyCharacterTokenTemplate extends AnyCharacterTokenTemplate implements java.io.Serializable{
    private String saveName;

    public Object clone () {
        return new SavingAnyCharacterTokenTemplate(saveName);
    }

    /**
     * @param saveName This string will be used as key when saving information in the pointer objects.
     */
    public SavingAnyCharacterTokenTemplate(String saveName) {
        super(false);
        this.saveName = saveName;
    }

    /**
     * Looks for a CharacterToken in the tokenSet and adds it to the Pointer
     * (using the earlier supplied key)
     */
    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        StringBuffer temp = (StringBuffer) pointer.get(saveName);
        if (temp == null) {
            temp = new StringBuffer();
            pointer.set(saveName,temp);
        }
        Vector begin = tokenSet.getBeginningTokens();
        for (int i=0;i<begin.size();i++) {
            if (begin.elementAt(i) instanceof CharacterToken) temp.append(((CharacterToken) begin.elementAt(i)).c);
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof SavingAnyCharacterTokenTemplate) {
            SavingAnyCharacterTokenTemplate temp = (SavingAnyCharacterTokenTemplate) other;
            if (temp.saveName == saveName) return true;
        }
        return false;
    }
}
