package de.fzi.wim.trie.extractor.character;

import java.util.Vector;

/**
 * A class offerings some convenience methods to create Templates for Strings.
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class CharacterTokenTemplateFactory {
    /**
     * Creates Whitespace & Character (and not confidence decreasing
     * any tokens in case a character is recognized as "unknown")
     * Token templates for the supplied string.
     */
    public static Vector createSimpleTemplates(String string) {
        Vector tokens = new Vector();
        CharacterToken.createCharacterTokens (tokens,string);
        Vector templates = new Vector(string.length());
        for (int i=0;i<tokens.size();i++) {
            CharacterToken token = (CharacterToken) tokens.elementAt(i);
            if (token.isWhitespace()) {
                templates.addElement(new WhitespaceCharacterTokenTemplate());
            }
            else if (token.isUnknown()) {
                templates.addElement(new AnyCharacterTokenTemplate(false));
            }
            else {
                templates.addElement(new CharacterTokenTemplate(token.c));
            }
        }
        return templates;
    }
}
