package de.fzi.wim.trie.extractor.character;

import de.fzi.wim.trie.extractor.*;
import java.util.Vector;

/**
 * The class to match characters
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class CharacterTokenTemplate implements TokenTemplate, java.io.Serializable{

    /** a correct character increases the confidence by this number */
    public static final double INCREASE_CONFIDENCE = 0.05;
    private char c;

    public Object clone() {
        return new CharacterTokenTemplate(c);
    }

    public CharacterTokenTemplate (char c) {
        if (CharacterToken.IGNORE_CASE) this.c = Character.toLowerCase(c);
        else this.c = c;
    }

    public boolean satisfied (TokenSet tokenSet, Pointer pointer) {
        Vector temp = tokenSet.getBeginningTokens();
        for (int i=0;i<temp.size();i++) {
            if (temp.elementAt(i) instanceof CharacterToken) {
                CharacterToken current = (CharacterToken) temp.elementAt(i);
                if (current.c == c) {
                    pointer.changeConfidence(INCREASE_CONFIDENCE);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof CharacterTokenTemplate) {
            if (c == ((CharacterTokenTemplate)other).c) return true;
        }
        return false;
    }

}
