package de.fzi.wim.trie.extractor.character;

import de.fzi.wim.trie.extractor.*;

public class AnyCharacterTokenTemplate implements TokenTemplate, java.io.Serializable {

    public static double DECREASE_CONFIDENCE =  -0.30;

    private boolean decreaseConfidence = true;


    public Object clone() {
        return new AnyCharacterTokenTemplate(decreaseConfidence);
    }

    /**
     * @param decreaseConfidence set this to true, if you want the pointer confidence to decrease each time this template accepts a token
     */
    public AnyCharacterTokenTemplate(boolean decreaseConfidence) {
        this.decreaseConfidence = decreaseConfidence;
    }

    /**
     * Accepts anything, but decreases the confidence (if set so in the constructor)
     */
    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        if (decreaseConfidence) {
            pointer.changeConfidence(DECREASE_CONFIDENCE);
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof AnyCharacterTokenTemplate) {
            if (decreaseConfidence == ((AnyCharacterTokenTemplate)other).decreaseConfidence) return true;
        }
        return true;
    }
}
