package de.fzi.wim.trie.extractor;

import java.io.Serializable;

/**
 * Representing the condition on an arc of a Trie
 * Please note that TokenTemplates are assumed to be STATELESS and
 * IMMUTABLE (at least if a levenstein trie is used).
 *
 * @author <a href="zach@fzi.de>Valentin Zacharias</a>
 */
public interface TokenTemplate extends Serializable{

    /**
     * Returns true if and only if the conditions stored in this template
     * are satisfied by the current tokenSet.<br>
     * Be careful - depending on the TokenTemplate implementation, it may
     * use lazy evaluation.<br>
     * Never change the vectors returned by the tokenSet.
     */
    public boolean satisfied(TokenSet tokenSet, Pointer pointer);

    public Object clone();
}
