package de.fzi.wim.trie.extractor;

import java.util.HashMap;
import java.util.Iterator;

/**
 * A class representing a pointer in the Trie.
 *
 * @author <a href=zach@fzi.de>Valentin Zacharias</a>
 */
public class Pointer {

    private double confidence =  1.0;
    private int beginIndex;
    private HashMap data;
    private TrieNode node;

    /**
     * If the confidence decreases BELOW this level, the pointer is discarded.
     */
    public static double MINIMUM_CONFIDENCE = 0.75;

    /**
     * Only if the confidence is higher or equal to this level, listener
     * objects are notified. Normally this number is higher than the
     * Minimum confidence.
     */
    public static double NOTIFY_CONFIDENCE = 0.81;

    private Pointer() {
    }

    public Pointer(TrieNode root, int beginIndex) {
        this.beginIndex = beginIndex;
        node = root;
    }

    public int getBeginIndex() {
        return beginIndex;
    }

    public TrieNode getTrieNode() {
        return node;
    }

    public void setTrieNode(TrieNode node) {
        this.node = node;
    }

    /**
     * Makes a deep copy of an pointer ...
     */
    public Object clone() {
        Pointer clone = new Pointer();
        clone.confidence = confidence;
        clone.beginIndex = beginIndex;
        if (data != null) {
            HashMap hash = new HashMap();
            Iterator it = data.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (data.get(key) instanceof StringBuffer) {
                    hash.put(key, new StringBuffer( ((StringBuffer) data.get(key)).toString()));
                }
                else {
                    hash.put(key, data.get(key));
                }
            }
            clone.data = hash;
        }
        return clone;
    }

    /**
     * Normally one, the confidence may decrease as unsure matchings are done
     * one the way.
     */
    public double getConfidence() {
        return confidence;
    }

    /**
     * Changes the confidence - normally this will be a decrease. The new
     * confidence is calculated as confidence += change;
     */
    public void changeConfidence(double change) {
        confidence += change;
    }

    /**
     * Gives the opportunity to save data in the internal HashSet. If a class
     * expects the data object to be cloned in the case of an pointer clone,
     * the data object needs to be a StringBuffer!
     */
    public void set (Object key, Object data) {
        if (this.data == null) this.data = new HashMap();
        this.data.put(key,data);
    }

    /**
     * Gives the opportunity to save data in the internal HashSet.
     */
    public Object get(Object key) {
        if (data == null) return null;
        else return data.get(key);
    }

}
