package de.fzi.wim.trie.extractor;

/**
 * Representing a TrieListener that checks if the recognized elements overlap before
 * they are passed on to the contained TrieListener (of overlapping elements only the
 * one with the highest confidence ist kept). You have to call "end()" on these
 * objects after the parsing is complete (otherwise some elements are lost).
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class OverlapTrieListener implements TrieListener {
    private TrieListener listener;
    private Pointer pointer;
    private int currentEndIndex;
    String id;

    public Object clone() {
        return new OverlapTrieListener((TrieListener)listener.clone());
    }

    public OverlapTrieListener(TrieListener listener) {
        this.listener = listener;
    }

    public void end() {
        if (pointer != null) {
            listener.notify(pointer,currentEndIndex,id);
        }
        pointer = null;
    }

    public void notify(Pointer pointer, int endIndex, String id) {
        this.id = id;
        if (this.pointer == null) {
            this.pointer = (Pointer) pointer.clone();
            currentEndIndex = endIndex;
        }
        else if (pointer.getBeginIndex() > currentEndIndex) {
            listener.notify(this.pointer,currentEndIndex, id);
            this.pointer = (Pointer) pointer.clone();
            currentEndIndex = endIndex;
        }
        else { //there is some degree of overlap ...
            if (pointer.getConfidence() > this.pointer.getConfidence()) {
                if ((currentEndIndex - pointer.getBeginIndex()) > 1) {
                    currentEndIndex = endIndex;
                    this.pointer = (Pointer) pointer.clone();
                }
                else if ((endIndex - this.pointer.getBeginIndex()) > 1) {
                    currentEndIndex = endIndex;
                    this.pointer = (Pointer) pointer.clone();
                }
            }
        }

    }

}
