package de.fzi.wim.trie.extractor;

import java.util.Vector;

/**
 * A generalization of the logical OR, it returns true if at least a specified
 * threshold of the contained TokenTemplate methods return true
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class NumericOrTokenTemplate implements TokenTemplate{
    private TokenTemplate[] templates;
    private int threshold;

    public Object clone() {
        TokenTemplate[] newTemplates = new TokenTemplate[templates.length];
        for (int i=0;i<templates.length;i++) {
            newTemplates[i] = (TokenTemplate) templates[i].clone();
        }
        return new NumericOrTokenTemplate(newTemplates,threshold);
    }


    /**
     * Returns true if at least <threshold> of the contained Templates return
     * true (lazy evaluation !)
     */
    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        int number = 0;
        for (int i=0;i<templates.length;i++) {
            if (templates[i].satisfied(tokenSet, pointer)) {
                number++;
                if (number >= threshold) return true;
            }
        }
        return false;
    }

    public NumericOrTokenTemplate(Vector templates, int threshold) {
        this.templates = new TokenTemplate[templates.size()];
        for (int i=0;i<this.templates.length;i++) {
            this.templates[i] = (TokenTemplate) templates.elementAt(i);
        }
        this.threshold = threshold;
    }

    public NumericOrTokenTemplate (TokenTemplate[] templates, int threshold) {
        this.templates = templates;
        this.threshold = threshold;
    }

    public NumericOrTokenTemplate(TokenTemplate one, TokenTemplate two, int threshold) {
        templates = new TokenTemplate[2];
        templates[0] = one;
        templates[1] = two;
        this.threshold = threshold;
    }

    /**
     * this equals method has a "cheap" implementation: for each of the
     * contained templates it looks for one "equal" template in the other object.
     * If one is found for all contained templates and the other object has
     * the same number of templates (and the same threshold and logical function)
     * true is returned.<br>
     * This can lead to wrong results! (but it's pretty fast)
     */
    public boolean equals (Object other) {
        if (other instanceof NumericOrTokenTemplate) {
            if (threshold == ((NumericOrTokenTemplate) other).threshold) {
                TokenTemplate[] otherTemplates = ((NumericOrTokenTemplate) other).templates;
                if (otherTemplates.length == templates.length) {
                    for (int x=0;x<templates.length;x++) {
                        boolean found = false;
                        for (int y=0;y<otherTemplates.length;y++) {
                            if (templates[x].equals(otherTemplates[y])) {
                                found = true;
                                break;
                            }
                        }
                        if (!found) return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

}
