package de.fzi.wim.trie.extractor;

/**
 * Well, maybe you guessed it- the logical OR
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class NotTokenTemplate implements TokenTemplate {

    private TokenTemplate template;

    public Object clone() {
        return new NotTokenTemplate((TokenTemplate)template.clone());
    }

    public NotTokenTemplate(TokenTemplate template) {
        this.template = template;
    }

    /**
     * Returns true if the contained template returns false (and vice versa)
     */
    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        return !(template.satisfied(tokenSet, pointer));
    }

    public boolean equals (Object other) {
        if (other instanceof NotTokenTemplate) {
            return template.equals( ((NotTokenTemplate)other).template);
        }
        return false;
    }
}
