package de.fzi.wim.trie.extractor;

import java.util.Vector;
import de.fzi.wim.trie.extractor.character.*;

/**
 * A very simple Generic Token Template - it is created from one token and its
 * satisfied method will return always when this token is contained in one
 * of the vectors the token set returns.
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class GenericTokenTemplate implements TokenTemplate{

    private Token token;

    public Object clone() {
        return new GenericTokenTemplate(token);
    }

    public GenericTokenTemplate(Token token) {
        this.token = token;
    }

    /**
     * Generates generate token templates for all tokens contained in the given
     * vector. All tokens at a given time will connected with an logical and.
     */
    public static Vector createGenericTokenTemplates(Vector tokens) {
         TokenTraverseStore store = new TokenTraverseStore(tokens);
         Vector toReturn = new Vector();
         while (store.next()) {
            toReturn.addElement(generateTokenTemplate(store));
         }
         return toReturn;
    }

    /**
     * the same like createGenericTokenTemplates, but everything will be saved
     * in the pointer under name "name"
     */
    public static Vector createGenericSavingTokenTemplates(Vector tokens, String name) {
        TokenTraverseStore store = new TokenTraverseStore(tokens);
        TokenTemplate saving = new SavingAnyCharacterTokenTemplate(name);
        Vector toReturn = new Vector();
        while (store.next()) {
            toReturn.addElement(generateTokenTemplate(store,saving));
        }
        return toReturn;
    }

    private static TokenTemplate generateTokenTemplate(TokenSet set, TokenTemplate saving) {
        Vector current = new Vector();
        current.addAll(set.getBeginningTokens());
        current.addAll(set.getEndingTokens());
        current.addAll(set.getCurrentTokens());
        if (current.size() == 0) {
            return saving;
        }
        else {
            for (int i=0;i<current.size();i++) {
                Token currentToken = (Token) current.elementAt(i);
                current.set(i,new GenericTokenTemplate(currentToken));
            }
            current.addElement(saving);
            return new NumericOrTokenTemplate(current,current.size());
        }
    }

    private static  TokenTemplate generateTokenTemplate(TokenSet set) {
        Vector current = new Vector();
        current.addAll(set.getBeginningTokens());
        current.addAll(set.getEndingTokens());
        current.addAll(set.getCurrentTokens());
        if (current.size() == 1) {
            return new GenericTokenTemplate( (Token) current.elementAt(0));
        }
        else if (current.size() == 0) {
            return new AnyTokenTemplate(false);
        }
        else {
            for (int i=0;i<current.size();i++) {
                Token currentToken = (Token) current.elementAt(i);
                current.set(i,new GenericTokenTemplate(currentToken));
            }
            return new NumericOrTokenTemplate(current,current.size());
        }
    }

    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        boolean toReturn = false;
        toReturn = toReturn || checkTokenVector(tokenSet.getBeginningTokens());
        toReturn = toReturn || checkTokenVector(tokenSet.getEndingTokens());
        toReturn = toReturn ||checkTokenVector(tokenSet.getCurrentTokens());
        if (toReturn) pointer.changeConfidence(Trie.INCREASE_CONFIDENCE);
        return toReturn;
    }

    private boolean checkTokenVector(Vector vector) {
        for (int i=0;i<vector.size();i++) {
            Token other = (Token) vector.elementAt(i);
            if (other.equals(token)) return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof GenericTokenTemplate) {
            GenericTokenTemplate other = (GenericTokenTemplate) o;
            if (other.token.equals(token)) return true;
            else return false;
        }
        else {
            return false;
        }
    }

}
