package de.fzi.wim.trie.extractor;

/**
 * A generic token that stores one object and the indizes for this object.
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class GenericToken extends Token implements java.io.Serializable{
    private Object object;

    /**
     * As a little workaround this equals method ignores indices !!!
     */
    public boolean equals(Object other) {
        if (other instanceof GenericToken) {
            GenericToken gt = (GenericToken) other;
            return gt.object.equals(object);
        }
        return false;
    }

    public GenericToken(int begin, int end, Object object) {
        super(begin,end);
        this.object = object;
    }

    public Object getTokenObject() {
        return object;
    }

    public String toString() {
        return "Generic Token - "+ object.toString();
    }
}
