package de.fzi.wim.trie.extractor;

/**
 * Information about a lexicon entry found in the text.
 * @author <a href="mailto:zach@fzi.de">Valentin Zacharias
 */
public class EntryLocationImpl implements de.fzi.wim.trie.EntryLocation {

    private Object reference;
    private int begin;
    private int end;
    private double confidence;

    public EntryLocationImpl(int begin, int end, Object reference, double confidence) {
        this.begin = begin;
        this.end = end;
        this.reference = reference;
        this.confidence = confidence;
    }

    public double getConfidence() {
        return confidence;
    }

    /**
     * Returns the referenced objects for this entry.
     */
    public Object getReference() {
        return reference;
    }

    /**
     * Returns the location of this entrys beginning in the text.
     */
    public int getBegin() {
        return begin;
    }

    /**
     * The end of the entry in the text.
     */
    public int getEnd() {
        return end;
    }
}
