package de.fzi.wim.trie.extractor;

/**
 * A container for any other TokenTemplate object. This classes
 * satisfied method returns the sames as the satisfied method of the
 * contained TokenTemplate object, but the condifence is decreased.
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class DecreaseConfidenceTokenTemplate implements TokenTemplate {

    private TokenTemplate template;

    public Object clone() {
        return new DecreaseConfidenceTokenTemplate((TokenTemplate) template.clone());
    }

    public DecreaseConfidenceTokenTemplate(TokenTemplate template) {
        this.template = template;
    }

    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        pointer.changeConfidence(Trie.DECREASE_CONFIDENCE);
        return template.satisfied(tokenSet,pointer);
    }

    public boolean equals (Object other) {
        if (other instanceof DecreaseConfidenceTokenTemplate) {
            return template.equals( ((DecreaseConfidenceTokenTemplate)other).template);
        }
        else {
            return false;
        }
    }

}
