package de.fzi.wim.trie.extractor;

/**
 * A template accepting everything, but decreasing the confidence.
 */
public class AnyTokenTemplate implements TokenTemplate{

    private boolean decreaseConfidence = true;

    public Object clone() {
        return new AnyTokenTemplate(decreaseConfidence);
    }

    public AnyTokenTemplate() {
    }

    public AnyTokenTemplate(boolean decreaseConfidence) {
        this.decreaseConfidence = decreaseConfidence;
    }

    /**
     * Accepts anything, but decreases the confidence (if set so in the
     * constructor)
     */
    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        if (decreaseConfidence) pointer.changeConfidence(Trie.DECREASE_CONFIDENCE);
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof AnyTokenTemplate) {
            if (decreaseConfidence == ((AnyTokenTemplate)other).decreaseConfidence) return true;
        }
        return false;
    }

}
