package de.fzi.wim.trie.extractor;

import java.util.Vector;

/**
 * Represents the logical AND and between two or more TokenTemplate objects
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias</a>
 */
public class AndTokenTemplate implements TokenTemplate {

    private TokenTemplate[] templates;

    public Object clone() {
        TokenTemplate[] newTemplates = new TokenTemplate[templates.length];
        for (int i=0;i<templates.length;i++) {
            newTemplates[i] = (TokenTemplate) templates[i].clone();
        }
        return new AndTokenTemplate(newTemplates);
    }

    /**
     * Returns true if all contained templates satisfied method returns true (and
     * optimizes the data structure on the fly)
     */
    public boolean satisfied(TokenSet tokenSet, Pointer pointer) {
        for (int i=0;i<templates.length;i++) {
            if (!templates[i].satisfied(tokenSet, pointer)) {
                //assuming that a conditions that fails is more likely to fail in the
                //future, it is placed in the beginning of the array
                TokenTemplate temp = templates[0];
                templates[0] = templates[i];
                templates[i] = temp;
                return false;
            }
        }
        return true;
    }

    public AndTokenTemplate(Vector templates) {
        this.templates = new TokenTemplate[templates.size()];
        for (int i=0;i<this.templates.length;i++) {
            this.templates[i] = (TokenTemplate) templates.elementAt(i);
        }
    }

    public AndTokenTemplate (TokenTemplate[] templates) {
        this.templates = templates;
    }

    public AndTokenTemplate(TokenTemplate one, TokenTemplate two) {
        templates = new TokenTemplate[2];
        templates[0] = one;
        templates[1] = two;
    }

    /** this equals method has a "cheap" implementation: for each of the
     * contained templates it looks for one "equal" template in the other object.
     * If one is found for all contained templates and the other object has
     * the same number of templates (and the same threshold and logical function)
     * true is returned.  <br>
     * This can lead to wrong results! (but it's pretty fast)
     */
    public boolean equals (Object other) {
        if (other instanceof AndTokenTemplate) {
            TokenTemplate[] otherTemplates = ((AndTokenTemplate) other).templates;
               if (otherTemplates.length == templates.length) {
                for (int x=0;x<templates.length;x++) {
                    boolean found = false;
                    for (int y=0;y<otherTemplates.length;y++) {
                           if (templates[x].equals(otherTemplates[y])) {
                               found = true;
                               break;
                           }
                       }
                    if (!found) return false;
                   }
                return true;
               }
           }
        return false;
    }

}
