package de.fzi.wim.trie.deterministic;

import java.util.Vector;
import de.fzi.wim.trie.Trie;

/**
 * A very simple Trie that finds all occurrences of synonyms supplied files.
 * It uses only the very basic LexiconStructure functionality and therefore
 * does not support ontology changes - i.e. after any change to the ontology
 * a new OntoloyParser must be created.
 *
 * @author <a href="zach@fzi.de">Valentin Zacharias </a>
 */
public class TrieImpl implements Trie {
 	private LexiconStructure lexi;
    private Vector locations = new Vector();

    public TrieImpl() {
        this.lexi = new LexiconStructureImpl();
    }

    /**
     * Included to implement Parser interface, returns always "false" because
     * this structur can only recognize strings without errors.
     */
    public boolean setAllowWrong(boolean allowWrong) {
        return false;
    }

    /**
     * Looks for Synonyms in the supplied string.
     * @return          a list of EntryLocation object, where the References vector always contains Concept or Instance objects.
     */
    public Vector parse(String toParse) {
        LexiconChecker tc = lexi.getLexiconChecker();
        locations.clear();

        for (int i=0;i<toParse.length();i++) {
			if (tc.nextChar(toParse.charAt(i))) {
                while (tc.hasMoreEntryLocations()) {
                    locations.add(tc.getEntryLocation());
                }
            }
        }
        return locations;
    }

    public void addReference(String key, Object reference) {
        lexi.addEntry(key, reference);
    }

}
