package de.fzi.wim.trie.deterministic;

/**
 * Representing a data structure to parse a text against a lexicon.
 *
 * @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
 * @version 19.12.2001
 */
public interface LexiconStructure {

    /** Adds a entry from the lexiconStructure. If the "entry" is already
    * contained in the trie, the reference is added to to this entry (any entry
    * may have more than one refernced object).
    * @param entry The string from the object
    * @param reference The refernced object.
    */
    public void addEntry(String entry, Object reference);

    /** Removes an en entry from the lexicon, any references to this entry
    * are deleted.
    * @return           true, if the entry was contained in the Trie, false otherwise.
    */
    public boolean removeEntry(String entry);

    /** Removes a entry-reference relation.. If there are other
    * references for this entry, the entry will remain in the LexiconStrucure, otherwise
    * it's deleted. The Object.equals method is used to compare reference
    * objects.
    * @return           0 if the entry-reference relation was not contained,
    *                   1 if it was and the entry was deleted, 2 if it was contained but the entry
    *                   is still in the LexiconStructure(because it has other references).
    */
    public int removeEntryReference(String entry, Object reference);

    /** Removes all occurrences of objects equal to the supplied "reference"
    * object from the LexiconStrucutre. This may result in entry Strings beeing deleted.
    * Depending on the implementation, this method may take a while.
    * @return           The number of objects equal to the reference object found.
    */
    public int removeReference(Object reference);

    /**
    * Replaces all ocurrences of objects equal to the supplied object "oldR"
    * and replaces them with "newR". Depending on the implementation,
    * this method may take a while.
    * @return           the number of replacements made.
    */
    public int replaceReference(Object oldR, Object newR);

    /**
    * After some deletions, changes the data structure may slow the parsing down.
    * Use this (very expensive) method to optimize the data structure.
    */
    public void optimize();

    public LexiconChecker getLexiconChecker();
}
