package de.fzi.wim.trie.deterministic;

import java.util.NoSuchElementException;

import de.fzi.wim.trie.EntryLocation;

/**
 * A low level interface to check a text against a lexicon stored in a LexiconStrucutre.
 *
 * @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
 */
public interface LexiconChecker {

    /**
     * Adds an event Listener that is notified anytime a lexicon
     * entry is found.
     */
    public void addLexiconCheckerListener(LexiconCheckerListener tcl);
    public void removeLexiconCheckerListener(LexiconCheckerListener tcl);

    /**
     * Use this method and travers the text.
     * @return      Returns true if at least one reference has been found. Use
     *              getEntryLocation and hasMoreEntryLocations to find out more.
     */
    public boolean nextChar(char c);

    /**
     * Returns a EntryLocation found by the last call to nextChar or throws
     * an exception if no entry was found. Please note that more than one
     * Lexicon entry can be found at any given time (if the lexicon contains
     * "bubab" and "bab" the last char of the input text "bubab" will result
     * in two created EntryLocations.
     */
    public EntryLocation getEntryLocation() throws NoSuchElementException;

    /**
     * Returns true if and only if at least one more object is returned by
     * getReference
     */
    public boolean hasMoreEntryLocations();
}
