package de.fzi.wim.trie.deterministic;

import java.util.Vector;

import de.fzi.wim.trie.EntryLocation;

/**
 * The EntryLocation class for compability with the de.fzi.wim.trie.EntryLocation interface
 *
 * @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
 */
public class EntryLocationImpl implements EntryLocation {
    private Object ref;
    private int begin;
    private int end;

    public EntryLocationImpl(Object ref, int begin, int end) {
        this.ref = ref;
        this.begin = begin;
        this.end = end;
    }

    private EntryLocationImpl(Vector vec, int index, int begin, int end) {
        this.ref = vec.elementAt(index);
        this.begin = begin;
        this.end = end;
    }

    public int getBegin() {
        return begin;
    }

    public int getEnd() {
        return end;
	}

    public double getConfidence() {
        return 1.0;
    }

    public Object getReference() {
        return ref;
    }
}
