package de.fzi.wim.trie;

import java.util.Vector;

/**
 * A very simple interface to parsers that use the information contained in the
 * synonyms, stems and labels of an ontology to find references to named
 * entities in the text.
 *
 * @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
 */
public interface Trie {
    /**
     * Determines if the parser should recognize slighly wrong strings. Default
     * is false.
     *
     * @return                  true if this trie implements this functionality, false otherwise
     */
    public boolean setAllowWrong(boolean allowWrong);

    /**
     * Adds a reference to the trie.
     *
     * @param key               key of the entry
     * @param reference         reference of the entry
     */
    public void addReference(String key, Object reference);

    /**
     * Parses the given string and returns a Vector containing the EntryLocation objects found.
     */
    public Vector parse(String string);

}
