package de.fzi.wim.trie;

/**
 * Representing a reference to an ontology entity found in the text.
 *
 * @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
 */
public interface EntryLocation {

    /**
     * Object found in the text
     */
    public Object getReference();

    /**
     * A value representing the confidence in this reference (it increases with
     * the length of the word and decreases if the word includes missing or wrong
     * characters). If only exact matching strings are recognized (as with the
     * Trie implementation) this method may always return 1.
     */
    public double getConfidence();

    /**
     * The beginning index of the reference to this object in the text
     */
    public int getBegin();

    /**
     * The ending index of the reference to this object in the text
     */
    public int getEnd();

}



