package de.fzi.wim.similarity;


import java.util.Vector;
import java.util.HashMap;

import java.io.IOException;
import java.io.File;

import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.oimodel.OIModel;
import edu.unika.aifb.kaon.api.oimodel.Instance;

/**
* An extension of the abstract Similarity class, that does not actually calculates the
* similarites, but loads them from an stored SimilarityMatrix object.
* @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
*/
public class SimilarityPrecomputedImpl extends Similarity {

    private SimilarityMatrix simMatrix;
    private HashMap mostSimilarCache = new HashMap();

    public SimilarityPrecomputedImpl(File file, OIModel oimodel) throws IOException, KAONException {
        try {
            simMatrix = new SimilarityMatrix(file,oimodel);
        } catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.toString());
        }
    }


    /**
    * Returns the most similar instances.
    * @param excludeThreshold Instances with a similarity less then "excludeThreshold" are never returned.
    * @param includeThreshold Instance with a similarity higher than "includeThreshold" are always included (but
    *   never more than "maxNumber".
    * @param normalNumber If "includeThreshold" and "excludeThreshold" do not determine the number of returned instances,
    *   the number of returned instance is "normalNumber".
    * @param maxNumber The method is guaranteed to never return more than maxNumber instances.
    */
    public Vector getMostSimilar(Instance inst, double excludeThreshold, double includeThreshold, int normalNumber, int maxNumber) {
        return simMatrix.getMostSimilar(inst,excludeThreshold,includeThreshold,normalNumber,maxNumber);
    }

    public double calculateSimilarity(Instance inst1, Instance inst2) {
        return simMatrix.getSimilarity(inst1,inst2);
    }


}
