package de.fzi.wim.similarity;

import java.util.Vector;

import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.oimodel.Instance;

/**
* The main interface to access calculated similarites.
* @author <a href="zach@fzi.de">Valentin Zacharias</a>
*/
public abstract class Similarity {


	/** The recursion depth for property similarity */
	protected int maxDepth = 4;

	/** The weight for semantic similarity */
    protected double semSimWeight = 1;

    /** The weight for property similarity */
    protected double propSimWeight = 2;

	public void setMaxDepth(int maxDepth) {
		this.maxDepth = maxDepth;
	}
	public void setSemWeight(double semSimWeight) {
		this.semSimWeight=semSimWeight;
	}
	public void setPropWeight(double propSimWeight) {
		this.propSimWeight=propSimWeight;
	}

	/*
    * Returns the most similar Instances. These are ordered descending. The number of
    * instances may be somewhere between 0 and 8.
    */
    public Vector getMostSimilar(Instance inst) throws KAONException{
        return getMostSimilar(inst, 0.084,0.2,4,6);
    }


    /**
    * Returns the most similar instances.
    * @param excludeThreshold Instances with a similarity less then "excludeThreshold" are never returned.
    * @param includeThreshold Instance with a similarity higher than "includeThreshold" are always included (but
    *   never more than "maxNumber".
    * @param normalNumber If "includeThreshold" and "excludeThreshold" do not determine the number of returned instances,
    *   the number of returned instance is "normalNumber".
    * @param maxNumber The method is guaranteed to never return more than maxNumber instances.
    */
    public abstract Vector getMostSimilar(Instance inst, double excludeThreshold, double includeThreshold, int normalNumber, int maxNumber) throws KAONException;


    public abstract double calculateSimilarity(Instance inst1, Instance inst2) throws KAONException;

}
