package de.fzi.wim.similarity;

import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
* Calculates and caches the semantic similarity between two
* instances.
* @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
*/
public class SemanticSimilarity {

    private HashMap cache = new HashMap();

    /**
    * Calculates the semantic similarity between two instances.
    */
    public double getSimilarity(InstanceTupel instances) throws KAONException {
        Double result = (Double) cache.get(instances);
        if (result == null) { //to bad, i have to calculate it :-(
            result = new Double(  getSimilarity(instances.inst1, instances.inst2));
            cache.put(instances,result);
        }
        return result.doubleValue();
    }

    protected double getSimilarity(Instance inst1, Instance inst2) throws KAONException{
        if (inst1.equals(inst2)) {
            return 1.0;
        }
        else {
            Set cotopy1 = getSemanticCotopy(inst1);
            double sizeCotopy1 = cotopy1.size();
            Set cotopy2 = getSemanticCotopy(inst2);
            cotopy1.retainAll(cotopy2);
            double intersect = cotopy1.size();
            double union = sizeCotopy1 + cotopy2.size() - intersect;
            return (intersect / union)/2.0;
        }
    }


    protected Set getSemanticCotopy(Instance inst) throws KAONException{
        Set parents = inst.getParentConcepts();
        Set toReturn = new HashSet();
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            Concept current = (Concept) it.next();
	    toReturn.add(current);
            toReturn.addAll(current.getAllSuperConcepts());
        }
        return toReturn;
    }

}
