package de.fzi.wim.similarity;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.io.File;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
* The main class for the similarity classes.
* @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
*/
public class Main {
    private KAONConnection connection;
    private OIModel oimodel;
    private Similarity sim;

    private static final String[] helpString = {
        "Usage: Main <OIModelFile>",
        " -h       : brings up this help",
        " -f <file>: creates a file containing calculated similarites between all",
        "            instances of the current OI-model",
        "",
        "Example: Create similarity file: Main -f ont.sim ont.kaon" };



    private static void displayHelp() {
        for (int i=0;i<helpString.length;i++) {
            System.out.println(helpString[i]);
        }
    }


    public static void main(String[] args) throws Exception{
        File saveFile = null;
        String oimodelFile = null;
        Main main = new Main();

        if (args.length == 0) displayHelp();
        else {
            int i=0;
            while (i<args.length) {
                if (args[i].equals("-h")) displayHelp();
                else if (args[i].equals ("-f")) {
                    i++;
                    saveFile = new File(args[i]);
                }
                else {
                    oimodelFile = args[i];
                }
                i++;
            }
        }
        if (oimodelFile == null) displayHelp();
        else {
            main.loadOIModel(oimodelFile);
            if (saveFile != null) {
                SimilarityMatrix results = main.calculateAllSimilarities();
                results.save(saveFile);
            }
            else {
                main.test();
            }
        }
    }


    public SimilarityMatrix calculateAllSimilarities() throws KAONException {
        Concept root = oimodel.getRootConcept();
        Set allInstances = root.getAllInstances();
        sim = new SimilarityImpl(oimodel);
        SimilarityMatrix toReturn = new SimilarityMatrix(sim,allInstances);
        toReturn.calculate();
        return toReturn;
    }

    public void test() throws KAONException {
        Concept root = oimodel.getRootConcept();
        Set allInstances = root.getAllInstances();
        sim = new SimilarityImpl(oimodel);
        Iterator it = allInstances.iterator();
        Instance current = (Instance) it.next();
        Vector testData = sim.getMostSimilar(current, 0.084,0.2,15,15);
        for (int i=0;i<testData.size();i++) {
            Instance now = (Instance) testData.elementAt(i);
            System.out.println(now.getURI());
        }
    }


    public void loadOIModel(String modelURI) throws Exception {
        Map parameters=new HashMap();
        parameters.put(KAONManager.KAON_CONNECTION,"edu.unika.aifb.kaon.apionrdf.KAONConnectionImpl");
        connection=KAONManager.getKAONConnection(parameters);
        oimodel=connection.openOIModelPhysical(modelURI);
    }

}
