package de.fzi.wim.similarity;

import edu.unika.aifb.kaon.api.KAONException;
import edu.unika.aifb.kaon.api.oimodel.Instance;

/*
* A hashable class representing a tupel of instances. It's used to
* find already calculated comparisons between two instances in caches.
* @author <a href="mailto:zach@fzi.de">Valentin Zacharias</a>
*/
public class InstanceTupel {

    public Instance inst1;
    public Instance inst2;

    private int hashCode;


    public InstanceTupel(Instance inst1, Instance inst2) throws KAONException {
        this.inst1 = inst1;
        this.inst2 = inst2;
        String uris;
        if (inst1.getURI().compareTo(inst2.getURI()) > 0) {
            uris = inst1.getURI() + inst2.getURI();
        }
        else {
            uris = inst2.getURI() + inst1.getURI();
        }
        hashCode = uris.hashCode();
    }

    public int hashCode() {
        return hashCode;
    }

    public boolean equals(Object o) {
        InstanceTupel other = (InstanceTupel) o;
        if (other.inst1.equals(inst1)) {
            if (other.inst2.equals(inst2)) {
                return true;

            }
        }
        return false;
    }

}
