package de.fzi.wim.registry.gui.ui;

import java.util.Collection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.awt.Insets;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JList;
import javax.swing.DefaultListModel;
import javax.swing.JScrollPane;

import de.fzi.wim.guibase.localization.*;

import de.fzi.wim.registry.gui.*;

/**
 * Simple dialog for entering the data about a new creator entity.
 */
public class NewTermEntityDlg extends JDialog {
    /** Editor for term definition.*/
    protected JTextField m_termDefinition;
    /** Field for entering synonyms.*/
    protected JTextField m_synonym;
    /** The list showing the synonyms. */
    protected JList m_synonymsList;
    /** Set to <code>true</code> if dialog is contirmed. */
    protected boolean m_confirmed;
    protected RegistryModule m_registryModule;

    public NewTermEntityDlg(RegistryModule registryModule,String baseID) {
        super(registryModule.getAppDriver().getMainFrameWindow(),true);
        m_registryModule=registryModule;
        LocalizationManager localizationManager=m_registryModule.getAppDriver().getLocalizationManager();
        setTitle(localizationManager.getPhrase(baseID+".title"));
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        
        // create the buttons
        JButton okButton=localizationManager.getButton("oimodeler.OK");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                if (m_synonymsList.getModel().getSize()==0) {
                    // an entity can only be created when its name is specified
					JOptionPane.showMessageDialog(m_registryModule.getAppDriver().getMainFrameWindow(),m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.newTerm.noSynonymMessage"),m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.newTerm.noSynonymTitle"),JOptionPane.ERROR_MESSAGE);
                    m_synonym.requestFocus();
                    return;
                }
                m_confirmed=true;
                dispose();
            }
        });
        JButton cancelButton=localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                dispose();
            }
        });

        // create all editors
        m_termDefinition=new JTextField();
        m_termDefinition.setPreferredSize(new Dimension(300,m_termDefinition.getPreferredSize().height));
        // editor for synonyms
        m_synonymsList=new JList(new DefaultListModel());
        final JButton addSynonymButton=localizationManager.getButton("registry.newTerm.addSynonymButton");
        addSynonymButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                // only add the string to the list if it is not in the list yet
                String newElement=m_synonym.getText();
                if (newElement!=null && !"".equals(newElement)) {
                    for (Enumeration e = ((DefaultListModel)m_synonymsList.getModel()).elements();e.hasMoreElements();) {
                        if (newElement.equals((String)e.nextElement()))
                            return;
                    }
                    ((DefaultListModel)m_synonymsList.getModel()).addElement(newElement);
                }
            }
        });
        final JButton removeSynonymsButton=localizationManager.getButton("registry.newTerm.removeSynonymsButton");
        removeSynonymsButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                Object[] selection=m_synonymsList.getSelectedValues();
                for (int i=0;i<selection.length;i++)
                    ((DefaultListModel)m_synonymsList.getModel()).removeElement(selection[i]);
            }
        });
        m_synonym=new JTextField();
        m_synonym.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                addSynonymButton.doClick();
            }
        });
        
        // create a framed panel for the synonym selection
        JPanel synonymPanel=new JPanel(new GridBagLayout());
        synonymPanel.setBorder(BorderFactory.createTitledBorder(localizationManager.getPhrase(baseID+".synonymLabel")));
        // and add the synonym editors to panel
        GridBagConstraints gbc=new GridBagConstraints();
        gbc.insets = new Insets(0,0,0,0);
        gbc.ipadx = 0; gbc.ipady = 0;
		gbc.gridwidth = 1;gbc.gridheight = 1;
		gbc.weightx = 100;gbc.weighty = 100;
        gbc.gridx = 0;gbc.gridy = 0;
        // add the field to enter a synonym
        gbc.insets.left=5;
        gbc.weighty = 2;
        gbc.weightx = 90;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.CENTER;
        synonymPanel.add(m_synonym,gbc);
        // add the button to add a synonym to the list
        gbc.insets.left=5;
        gbc.insets.right=5;
        gbc.weighty = 2;
        gbc.weightx = 10;
        gbc.gridx = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.EAST;
        synonymPanel.add(addSynonymButton,gbc);
        // add the list for the synonyms
        gbc.insets.left=5;
        gbc.insets.top=5;
        gbc.insets.bottom=5;
        gbc.insets.right=0;
        gbc.weightx = 90;
        gbc.weighty = 96;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.CENTER;
        JScrollPane synonymscrollPane=new JScrollPane(m_synonymsList);
        synonymscrollPane.getViewport().setBackground(m_synonymsList.getBackground());
        synonymscrollPane.getViewport().setPreferredSize(new Dimension(300,200));
        synonymPanel.add(synonymscrollPane,gbc);
        // add the button to remove a synonym from the list
        gbc.insets.top=5;
        gbc.insets.left=5;
        gbc.insets.right=5;
        gbc.weightx = 10;
        gbc.gridx = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.NORTHEAST;
        synonymPanel.add(removeSynonymsButton,gbc);
        
        //add the term definition editor and the synonym pane to the main pane
        JPanel propertyPane=new JPanel(new GridBagLayout());
        gbc.insets = new Insets(5,5,5,5);
        gbc.ipadx = 0; gbc.ipady = 0;
		gbc.gridwidth = 1;gbc.gridheight = 1;
		gbc.weightx = 100;gbc.weighty = 100;
        gbc.gridx = 0;gbc.gridy = 0;
        // add the panel for the synonyms
        gbc.weighty = 94;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.CENTER;
        propertyPane.add(synonymPanel,gbc);
        // add a label for the term definition
        gbc.weighty = 2;
		gbc.gridy = 1;
        gbc.insets.bottom=0;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.SOUTHWEST;
        propertyPane.add(localizationManager.getLabel(baseID+".label"),gbc);
        // add the editor for the term definition
        gbc.insets.top=0;
        gbc.gridy = 2;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        propertyPane.add(m_termDefinition,gbc);
        // and add the buttons
        JPanel buttonsPane=new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        gbc.insets.top=5;
        gbc.insets.bottom=5;
        gbc.weighty = 2;
        gbc.gridy = 3;
        propertyPane.add(buttonsPane,gbc);
        setContentPane(propertyPane);
        getRootPane().setDefaultButton(okButton);
        pack();
        setLocationRelativeTo(m_registryModule.getAppDriver().getMainFrameWindow());
    }
    /**
     * Returns the term definition of the new term entity.
     *
     * @return                      term definition of the new term entity
     */
    public String getTermDefinition() {
        return m_termDefinition.getText();
    }
    /**
     * Sets the synonym label of the new term entity.
     *
     * @param newSynonymLabel                     new synonym label of the new term entity
     */
    public void setSynonymLabel(String newSynonymLabel) {
        m_synonym.setText(newSynonymLabel);
		m_synonym.selectAll();
    }
    /**
     * Returns the synonym labels that should be attached to this term.
     *
     * @return                      collection of synonym labels
     */
    public Collection getSynonymLabels() {
        ArrayList returnList=new ArrayList();
        
        for (Enumeration e = ((DefaultListModel)m_synonymsList.getModel()).elements();e.hasMoreElements();) {
            returnList.add((String)e.nextElement());
        }
        return returnList;
    }
    /**
     * Returns whether dialog was confirmed with OK.
     *
     * @return                      <code>true</code> if the dialog was confirmed
     */
    public boolean isConfirmed() {
        return m_confirmed;
    }
}