package de.fzi.wim.registry.gui.ui;

import java.awt.Insets;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JOptionPane;

import de.fzi.wim.guibase.localization.*;

import de.fzi.wim.registry.gui.*;

/**
 * Simple dialog for entering the data about a new entity.
 */
public class NewRegistryEntityDlg extends JDialog {
    /** Editor for entity name. */
    protected JTextField m_entityName;
    /** Set to <code>true</code> if dialog is contirmed. */
    protected boolean m_confirmed;
    protected RegistryModule m_registryModule;

    public NewRegistryEntityDlg(RegistryModule registryModule,String titleID) {
        super(registryModule.getAppDriver().getMainFrameWindow(),true);
        m_registryModule=registryModule;
        LocalizationManager localizationManager=registryModule.getAppDriver().getLocalizationManager();
        setTitle(localizationManager.getPhrase(titleID+".title"));
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        m_entityName=new JTextField();
        m_entityName.setPreferredSize(new Dimension(300,m_entityName.getPreferredSize().height));
        JButton okButton=localizationManager.getButton("oimodeler.OK");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (m_entityName.getText()==null || "".equals(m_entityName.getText())) {
                    // an entity can only be created when its name is specified
					JOptionPane.showMessageDialog(m_registryModule.getAppDriver().getMainFrameWindow(),m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.newEntity.noEntityNameMessage"),m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.newEntity.noEntityNameTitle"),JOptionPane.ERROR_MESSAGE);
                    m_entityName.requestFocus();
                    return;
                }
                m_confirmed=true;
                dispose();
            }
        });
        JButton cancelButton=localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        JPanel propertyPane=new JPanel(new GridBagLayout());
        GridBagConstraints gbc=new GridBagConstraints(0,0,1,1,1,0,GridBagConstraints.CENTER,GridBagConstraints.HORIZONTAL,new Insets(5,5,0,5),0,0);
        JLabel label=localizationManager.getLabel(titleID+".label");
        label.setHorizontalAlignment(JLabel.LEFT);
        propertyPane.add(label,gbc);
        gbc.gridy++;
        propertyPane.add(m_entityName,gbc);
        JPanel buttonsPane=new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        gbc.insets.bottom=5;
        gbc.gridy++;
        propertyPane.add(buttonsPane,gbc);
        setContentPane(propertyPane);
        getRootPane().setDefaultButton(okButton);
        pack();
        setLocationRelativeTo(registryModule.getAppDriver().getMainFrameWindow());
    }
    /**
     * Returns the name of the new entity.
     *
     * @return                      name of the new entity
     */
    public String getEntityName() {
        return m_entityName.getText();
    }
    /**
     * Sets the name of the entity.
     *
     * @param newEntityName                     new name of the new entity
     */
    public void setEntityName( String newEntityName ) {
        m_entityName.setText( newEntityName );
		m_entityName.selectAll();
    }
    /**
     * Returns whether dialog was confirmed with OK.
     *
     * @return                      <code>true</code> if the dialog was confirmed
     */
    public boolean isConfirmed() {
        return m_confirmed;
    }
}