package de.fzi.wim.registry.gui.ui;

import java.awt.Insets;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;

import de.fzi.wim.guibase.localization.*;

import de.fzi.wim.registry.gui.*;

/**
 * Simple dialog for entering the data about a new creator entity.
 */
public class NewPartyEntityDlg extends JDialog {
    /** Type selection button.*/
    protected JButton m_typeSelection;
    /** Editor for entity name.*/
    protected JTextField m_entityName;
    /** Editors for address information*/
    /** Editor for zip code*/
    protected JTextField m_zipCode;
    /** Editor for country name*/
    protected JTextField m_country;
    /** Editor for state name*/
    protected JTextField m_state;
    /** Editor for street name and number*/
    protected JTextField m_streetAndNumber;
    /** radio buttons for entity type*/
    JRadioButton m_personButton;
    JRadioButton m_organizationButton;
    /** Set to <code>true</code> if dialog is contirmed. */
    protected boolean m_confirmed;
    protected RegistryModule m_registryModule;

    public NewPartyEntityDlg(RegistryModule registryModule,String baseID) {
        super(registryModule.getAppDriver().getMainFrameWindow(),true);
        m_registryModule=registryModule;
        LocalizationManager localizationManager=registryModule.getAppDriver().getLocalizationManager();
        setTitle(localizationManager.getPhrase(baseID+".title"));
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        
        // create the buttons
        JButton okButton=localizationManager.getButton("oimodeler.OK");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (m_entityName.getText()==null || "".equals(m_entityName.getText())) {
                    // an entity can only be created when its name is specified
					JOptionPane.showMessageDialog(m_registryModule.getAppDriver().getMainFrameWindow(),m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.newEntity.noEntityNameMessage"),m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.newEntity.noEntityNameTitle"),JOptionPane.ERROR_MESSAGE);
                    m_entityName.requestFocus();
                    return;
                }
                m_confirmed=true;
                dispose();
            }
        });
        JButton cancelButton=localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        // create all editors
        m_zipCode=new JTextField();
        m_streetAndNumber=new JTextField();
        m_state=new JTextField();
        m_country=new JTextField();
        m_entityName=new JTextField();
        m_entityName.setPreferredSize(new Dimension(300,m_entityName.getPreferredSize().height));
        // the type selection
        m_personButton=localizationManager.getRadioButton(baseID+".personLabel");
        m_personButton.setActionCommand("person");
        m_personButton.setSelected(true);
        JRadioButton m_organizationButton=localizationManager.getRadioButton(baseID+".organizationLabel");
        m_organizationButton.setActionCommand("organization");
        //Group those radio buttons.
        ButtonGroup group = new ButtonGroup();
        group.add(m_personButton);
        group.add(m_organizationButton);
        // create a framed panel for the type selection
        JPanel typePanel=new JPanel(new GridBagLayout());
        typePanel.setBorder(BorderFactory.createTitledBorder(localizationManager.getPhrase(baseID+".typeLabel")));
        // and add the radion buttons to the panel
        GridBagConstraints gbc=new GridBagConstraints();
        gbc.insets = new Insets(0,0,0,0);
        gbc.ipadx = 0; gbc.ipady = 0;
		gbc.gridwidth = 1;gbc.gridheight = 1;
		gbc.weightx = 100;gbc.weighty = 50;
        gbc.gridx = 0;gbc.gridy = 0;
        // add the person radio button
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.WEST;
        typePanel.add(m_personButton,gbc);
        // add the organization radio button
        gbc.gridy = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.WEST;
        typePanel.add(m_organizationButton,gbc);
        // create a framed panel for the adress information
        JPanel adressPanel=new JPanel(new GridBagLayout());
        adressPanel.setBorder(BorderFactory.createTitledBorder(localizationManager.getPhrase(baseID+".addressLabel")));
        // and add the editors to the panel
        gbc.insets = new Insets(0,0,0,0);
        gbc.ipadx = 0; gbc.ipady = 0;
		gbc.gridwidth = 1;gbc.gridheight = 1;
		gbc.weightx = 100;gbc.weighty = 12;
        gbc.gridx = 0;gbc.gridy = 0;
        // add a label for the zipcode
        gbc.insets.left=5;
        gbc.insets.right=5;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.SOUTHWEST;
        adressPanel.add(localizationManager.getLabel(baseID+".zipLabel"),gbc);
        // add the editor for the zip code
		gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        adressPanel.add(m_zipCode,gbc);
        // add a label for the street
        gbc.insets.top=5;
        gbc.gridy = 2;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.SOUTHWEST;
        adressPanel.add(localizationManager.getLabel(baseID+".streetnameandnumberLabel"),gbc);
        // add the editor for the street
        gbc.insets.top=0;
		gbc.gridy = 3;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        adressPanel.add(m_streetAndNumber,gbc);
        // add a label for the state
        gbc.insets.top=5;
        gbc.gridy = 4;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.SOUTHWEST;
        adressPanel.add(localizationManager.getLabel(baseID+".stateLabel"),gbc);
        // add the editor for the street
        gbc.insets.top=0;
		gbc.gridy = 5;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        adressPanel.add(m_state,gbc);
        // add a label for the country
        gbc.insets.top=5;
        gbc.gridy = 6;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.SOUTHWEST;
        adressPanel.add(localizationManager.getLabel(baseID+".countryLabel"),gbc);
        // add the editor for the street
        gbc.insets.top=0;
        gbc.insets.bottom=5;
		gbc.gridy = 7;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        adressPanel.add(m_country,gbc);

        //add the name editor and the address pane to the main pane
        JPanel propertyPane=new JPanel(new GridBagLayout());
        gbc.insets = new Insets(5,5,5,5);
        gbc.ipadx = 0; gbc.ipady = 0;
		gbc.gridwidth = 1;gbc.gridheight = 1;
		gbc.weightx = 100;gbc.weighty = 100;
        gbc.gridx = 0;gbc.gridy = 0;
        // add a label for the name editor
        gbc.weighty = 2;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.SOUTHWEST;
        propertyPane.add(localizationManager.getLabel(baseID+".label"),gbc);
        // add the editor for the name
        gbc.insets.top=0;
		gbc.gridy = 1;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        propertyPane.add(m_entityName,gbc);
        // add the type pane
        gbc.insets.top=5;
        gbc.weighty = 10;
        gbc.gridy = 2;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.CENTER;
        propertyPane.add(typePanel,gbc);
        // add the address pane
        gbc.weighty = 74;
        gbc.gridy = 3;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.CENTER;
        propertyPane.add(adressPanel,gbc);
        // and add the buttons
        JPanel buttonsPane=new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        gbc.insets.bottom=5;
        gbc.weighty = 2;
        gbc.gridy = 4;
        propertyPane.add(buttonsPane,gbc);
        setContentPane(propertyPane);
        getRootPane().setDefaultButton(okButton);
        pack();
        setLocationRelativeTo(registryModule.getAppDriver().getMainFrameWindow());
    }
    /**
     * Returns the name of the new party entity.
     *
     * @return                      name of the new party entity
     */
    public String getEntityName() {
        return m_entityName.getText();
    }
    /**
     * Sets the name of the new party entity.
     *
     * @param newEntityName                     new name of the new party entity
     */
    public void setEntityName( String newEntityName ) {
        m_entityName.setText( newEntityName );
		m_entityName.selectAll();
    }
    /**
     * Returns the zip code for the new party entity.
     *
     * @return                      zip code
     */
    public String getZipCode() {
        return m_zipCode.getText();
    }
    /**
     * Returns the street name and number for the new party entity.
     *
     * @return                      street name and number
     */
    public String getStreetAndNumber() {
        return m_streetAndNumber.getText();
    }
    /**
     * Returns the country name for the new party entity.
     *
     * @return                      country name
     */
    public String getCountryName() {
        return m_country.getText();
    }
    /**
     * Returns the state name for the new party entity.
     *
     * @return                      state name
     */
    public String getStateName() {
        return m_state.getText();
    }
    /**
     * Returns if the new party entity should be a person.
     *
     * @return                      <code>true</code> if the entity should be a person, <code>false</code> otherwise
     */
    public boolean isPerson() {
        return m_personButton.isSelected();
    }
    /**
     * Returns if the new party entity should be a organization.
     *
     * @return                      <code>true</code> if the entity should be a organization, <code>false</code> otherwise
     */
    public boolean isOrganization() {
        return m_organizationButton.isSelected();
    }
    /**
     * Returns whether dialog was confirmed with OK.
     *
     * @return                      <code>true</code> if the dialog was confirmed
     */
    public boolean isConfirmed() {
        return m_confirmed;
    }
}