package de.fzi.wim.registry.gui.ui;

import java.awt.Insets;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JButton;
import javax.swing.JLabel;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.guibase.localization.*;

/**
 * The pane that can be used to manage the elements in the registry.
 */
public class ManageElementsPane extends JPanel {
    /** The registry viewable. */
    protected RegistryViewable m_registryViewable;
    /** The fields in which the OI-model was applied. */
    protected String m_appliedInFieldsName;
    /** The projects in which the OI-model was applied. */
    protected String m_appliedInProjectsName;
    /** The creators of the OI-model. */
    protected String m_creatorsName;
    /** The terms of the OI-model. */
    protected String m_termsName;
    /** The tabbed pane displaying the sources for the elements. */
    protected JTabbedPane m_sourcesTabbedPane;

    /**
     * Creates an instance of this pane.
     *
     * @param registryViewable                  the viewable
     */
    public ManageElementsPane(RegistryViewable registryViewable) {
        super(new GridBagLayout());
        m_registryViewable=registryViewable;
        m_sourcesTabbedPane = new JTabbedPane();

        LocalizationManager localizationManager=m_registryViewable.getModule().getAppDriver().getLocalizationManager();
        m_appliedInFieldsName=localizationManager.getPhrase("registry.search.Fields");
        m_appliedInProjectsName=localizationManager.getPhrase("registry.search.Projects");
        m_creatorsName=localizationManager.getPhrase("registry.search.Creators");
        m_termsName=localizationManager.getPhrase("registry.search.Terms");

        addElementSource( new OIModelInfoPane.PartyElementSource(m_registryViewable,m_creatorsName,m_creatorsName),localizationManager.getLabel("registry.search.searchLabel"),getButton(localizationManager,"registry.search.searchButton","registry.magnifier"),getButton(localizationManager,"registry.search.addButton","registry.asterisk"));
        addElementSource( new OIModelInfoPane.ProjectsElementSource(m_registryViewable,m_appliedInProjectsName,m_appliedInProjectsName),localizationManager.getLabel("registry.search.searchLabel"),getButton(localizationManager,"registry.search.searchButton","registry.magnifier"),getButton(localizationManager,"registry.search.addButton","registry.asterisk"));
        addElementSource( new OIModelInfoPane.ApplicationFieldsElementSource(m_registryViewable,m_appliedInFieldsName,m_appliedInFieldsName),localizationManager.getLabel("registry.search.searchLabel"),getButton(localizationManager,"registry.search.searchButton","registry.magnifier"),getButton(localizationManager,"registry.search.addButton","registry.asterisk"));
        addElementSource( new OIModelInfoPane.TermsElementSource(m_registryViewable,m_termsName,m_termsName),localizationManager.getLabel("registry.search.searchLabel"),getButton(localizationManager,"registry.search.searchButton","registry.magnifier"),getButton(localizationManager,"registry.search.addButton","registry.asterisk"));

        GridBagConstraints gbc=new GridBagConstraints();
        gbc.insets = new Insets(0,0,0,0);
        gbc.ipadx = 0; gbc.ipady = 0;
        gbc.gridwidth = 1;gbc.gridheight = 1;
        gbc.weightx = 100;gbc.weighty = 100;
        gbc.gridx = 0;gbc.gridy = 0;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.CENTER;
        add(m_sourcesTabbedPane,gbc);
    }
    /**
     * Adds a new element source to the selector.
     *
     * @param elementSource           an ElementSource object
     * @param searchLabel             the label displayed on top of the selection list
     * @param searchButton            the button for searching elements (may be <code>null</code>)
     * @param addButton               the button for adding elements (may be <code>null</code>)
     */
    public void addElementSource(ExtElementSelector.ElementSource elementSource,JLabel searchLabel,JButton searchButton,JButton addButton) {
        m_sourcesTabbedPane.addTab(elementSource.getDisplayName(), null, new ExtElementSelector.ElementSourcePanel(elementSource,searchLabel,searchButton,addButton), elementSource.getDisplayName());
        if ( m_sourcesTabbedPane.getSelectedIndex() == -1 )
            m_sourcesTabbedPane.setSelectedIndex(0);
    }
    /**
     * Returns a <code>JButton</code> with the specified text and icon.
     *
     * @param localizationManager               current Localization manager
     * @param buttonID                          ID to the text of the button
     * @param iconID                            ID to the icon of the button
     * @return                                  the name of the OI-model
     */
    protected JButton getButton(LocalizationManager localizationManager,String buttonID,String iconID) {
        JButton button = localizationManager.getButton(buttonID);
        button.setIcon(localizationManager.getImageIcon(iconID));
        return button;
    }
}
