package de.fzi.wim.registry.gui.actions;

import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.registry.gui.*;

/**
 * Saves the registry.
 */
public class SaveRegistry extends AbstractRegistryAction {

    public SaveRegistry(RegistryModule registryModule) {
        super(registryModule,"action.registry.saveRegistry");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            getViewable().getRegistry().getRegistryOIModelInstance().save();
        }
        catch (KAONException error) {
            m_registryModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled());
    }
}
