package de.fzi.wim.registry.gui.actions;

import java.awt.event.ActionEvent;

import de.fzi.wim.registry.gui.*;
import de.fzi.wim.registry.gui.ui.*;

/**
 * Refreshes the search with the currently entered parameters.
 */
public class RefreshSearch extends AbstractRegistryAction {

    public  RefreshSearch (RegistryModule registryModule) {
        super(registryModule,"action.registry.refreshSearch");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            getViewable().doSearch();
        }
        catch (Exception error) {
            m_registryModule.getAppDriver().displayErrorNotification(error);
        }
    }

    public void updateAction() {
        setEnabled( commandsAreEnabled() );
    }
}
