package de.fzi.wim.registry.gui.actions;

import java.util.Map;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.ui.*;

import de.fzi.wim.registry.api.*;
import de.fzi.wim.registry.gui.*;
import de.fzi.wim.registry.gui.ui.*;

/**
 * Action that opens an registry.
 */
public class OpenRegistry extends AbstractRegistryAction {

    public OpenRegistry(RegistryModule registryModule) {
        super(registryModule,"action.registry.openRegistry");
    }
    public void actionPerformed(ActionEvent e) {
        OpenOIModelDlg openOIModelDlg=new OpenOIModelDlg(m_registryModule,OpenOIModelDlg.OPEN_MODUS,"registry.openRegistry",null);
        openOIModelDlg.setVisible(true);
        String oimodelPhysicalURI=openOIModelDlg.getOIModelPhysicalURI();
        if (openOIModelDlg.isConfirmed() && oimodelPhysicalURI.length()!=0) {
            Map connectionParameters=openOIModelDlg.getConnectionParameters();
            try {
                m_registryModule.getAppDriver().startWaitState();
                try {
                    KAONConnection kaonConnection=KAONManager.getKAONConnection(connectionParameters);
                    try {
                        OIModel oimodel=kaonConnection.openOIModelPhysical(oimodelPhysicalURI);
                        m_registryModule.getAppDriver().newViewableAncor(new RegistryViewable(m_registryModule,new Registry(oimodel)));
                    }
                    catch (KAONException error) {
                        kaonConnection.close();
                        throw error;
                    }
                }
                finally {
                    m_registryModule.getAppDriver().endWaitState();
                }
            }
            catch (KAONException error) {
                m_registryModule.getAppDriver().displayErrorNotification(error);
            }
        }
    }
}
