package de.fzi.wim.registry.gui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.parameters.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.ui.*;

import de.fzi.wim.registry.api.*;
import de.fzi.wim.registry.gui.*;

/**
 * Opens the currently selected OI-models.
 */
public class OpenOIModel extends AbstractRegistryAction {

    public  OpenOIModel(RegistryModule registryModule) {
        super(registryModule,"action.registry.openOIModel");
    }
    public void actionPerformed(ActionEvent e) {
		try {
			OIModelerModule oimodelerModule=(OIModelerModule)m_registryModule.getAppDriver().getModule(OIModelerModule.NAME);

			Iterator resolvedOIModels=resolveParametersFromOIModels( getViewable().getCurrentOIModelInfos() ).iterator();

			// now open all oimodels with resolved parameters
            while (resolvedOIModels.hasNext()) {
				OIModelInfoParameters oimodelinfoparameters=(OIModelInfoParameters)resolvedOIModels.next();

				m_registryModule.getAppDriver().startWaitState();
                try {
					try {
						KAONConnection kaonConnection=KAONManager.getKAONConnection(oimodelinfoparameters.getParameters());
						try {
							OIModel oimodel=kaonConnection.openOIModelPhysical(oimodelinfoparameters.getOIModelInfo().getPhysicalURI());
							m_registryModule.getAppDriver().newViewableAncor(new OIModelerViewable(oimodelerModule,kaonConnection,oimodel));
						}
						catch (KAONException error) {
							kaonConnection.close();
							throw error;
						}
					}
					catch (KAONException error) {
						m_registryModule.getAppDriver().displayErrorNotification(error);
					}
                }
                finally {
					m_registryModule.getAppDriver().endWaitState();
                }
            }
        }
        catch (KAONException error) {
            m_registryModule.getAppDriver().displayErrorNotification(error);
        }
    }

    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getCurrentOIModelInfos().hasNext());
    }

	/**
     * Retrieves the connection parameters to the supplied OIModels. User will be asked for
     * missing parameters.
     *
     * @param oimodels                      list of OIModel objects
     * @return                              iterator of OIModelInfoParameters objects with resolved parameters
     * @throws KAONException                thrown if there is an error
     */
    protected List resolveParametersFromOIModels( Iterator oimodels ) throws KAONException {
		ArrayList resolvedOIModels=new ArrayList();        //list to store those oimodels and parameters that are resolved
		HashMap notresolvedOIModels=new HashMap();         //hashmap for oimodels that have not been resolved yet
		ArrayList notresolvedparameters=new ArrayList();   //list to store the not yet resolved parameters

		// iterate over all OIModels
		while (oimodels.hasNext()) {
			OIModelInfo oimodelInfo=(OIModelInfo)oimodels.next();
			Map parameters=KAONManager.getDefaultParametersForPhysicalURI(oimodelInfo.getPhysicalURI(),null);
			if (ParametersCompletionDlg.needsCompletion(parameters)) {
				// save those oimodels who needs to be completed
				String hashname=oimodelInfo.getLogicalURI();
				notresolvedOIModels.put(hashname,oimodelInfo);
				notresolvedparameters.add(new ParametersCompletionDlg.DefaultCompletionParametersInfo(hashname,parameters));
			}
			else {
				// save the ones that don't as well
				resolvedOIModels.add( new OIModelInfoParameters(oimodelInfo, parameters) );
			}
		}

		// resolve the parameters that need to be resolved
		if ( notresolvedparameters.size() > 0 ) {
			// show the dialog to resolve the parameters
			ParametersCompletionDlg parametersCompletionDlg=new ParametersCompletionDlg(m_registryModule.getAppDriver().getMainFrameWindow(),m_registryModule.getAppDriver().getLocalizationManager(),"registry.parametersCompletion",notresolvedparameters.iterator());
			parametersCompletionDlg.setVisible(true);
			if (parametersCompletionDlg.isConfirmed()) {
				Iterator iterator=notresolvedparameters.iterator();
				while (iterator.hasNext()) {
					// store the resolved parameters in the appropriate list
					String modelname=((ParametersCompletionDlg.ParametersInfo) iterator.next()).getName();
					resolvedOIModels.add( new OIModelInfoParameters( (OIModelInfo)notresolvedOIModels.get( modelname ), parametersCompletionDlg.getConnectionParameters( modelname ) ) );
				}
			}
		}

		return resolvedOIModels;
    }

	/**
	 * Class to store OIModelInfos and its parameters.
	 */
	protected class OIModelInfoParameters {
		protected OIModelInfo m_oimodelinfo;
		protected Map m_parameters;

		public OIModelInfoParameters( OIModelInfo oimodelinfo, Map parameters ) {
			m_oimodelinfo=oimodelinfo;
			m_parameters=parameters;
		}

		public OIModelInfo getOIModelInfo() {
			return m_oimodelinfo;
		}

		public Map getParameters() {
			return m_parameters;
		}

		public void setParameters( Map parameters ) {
			m_parameters=parameters;
		}
	}
}
