package de.fzi.wim.registry.gui.actions;

import java.util.Map;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.oimodeler.ui.*;

import de.fzi.wim.registry.api.*;
import de.fzi.wim.registry.gui.*;
import de.fzi.wim.registry.gui.ui.*;

/**
 * Action that opens a new registry.
 */
public class NewRegistry extends AbstractRegistryAction {

    public NewRegistry(RegistryModule registryModule) {
        super(registryModule,"action.registry.newRegistry");
    }
    public void actionPerformed(ActionEvent e) {
        OpenOIModelDlg openOIModelDlg=new OpenOIModelDlg(m_registryModule,OpenOIModelDlg.CREATE_MODUS,"registry.newRegistry",null);
        openOIModelDlg.setVisible(true);
        String oimodelPhysicalURI=openOIModelDlg.getOIModelPhysicalURI();
        if (openOIModelDlg.isConfirmed() && oimodelPhysicalURI.length()!=0) {
            String oimodelLogicalURI=openOIModelDlg.getOIModelLogicalURI();
            if (oimodelLogicalURI.length()==0)
                oimodelLogicalURI=oimodelPhysicalURI;
            Map connectionParameters=openOIModelDlg.getConnectionParameters();
            try {
                m_registryModule.getAppDriver().startWaitState();
                try {
                    KAONConnection connection=KAONManager.getKAONConnection(connectionParameters);
                    try {
                        OIModel oimodel=connection.createOIModel(oimodelPhysicalURI,oimodelLogicalURI);
                        m_registryModule.getAppDriver().newViewableAncor(new RegistryViewable(m_registryModule,new Registry(oimodel)));
                    }
                    catch (KAONException error) {
                        connection.close();
                        throw error;
                    }
                }
                finally {
                    m_registryModule.getAppDriver().endWaitState();
                }
            }
            catch (KAONException error) {
                m_registryModule.getAppDriver().displayErrorNotification(error);
            }
        }
    }
}
