package de.fzi.wim.registry.gui.actions;

import java.util.Iterator;
import javax.swing.JOptionPane;
import java.awt.event.ActionEvent;

import edu.unika.aifb.kaon.api.*;

import de.fzi.wim.registry.api.*;
import de.fzi.wim.registry.gui.*;
import de.fzi.wim.registry.gui.ui.*;

/**
 * Deletes the currently selected OI-models from the registry.
 */
public class DeleteOIModelInfo extends AbstractRegistryAction {

    public  DeleteOIModelInfo (RegistryModule registryModule) {
        super(registryModule,"action.registry.deleteOIModelInfo");
    }
    public void actionPerformed(ActionEvent e) {
        try {
            Iterator iterator=getViewable().getCurrentOIModelInfos();
            if (iterator.hasNext()) {
                String message=m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.DeleteOIModelInfo.ConfirmMessage");
                String title=m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.DeleteOIModelInfo.ConfirmTitle");
                int result=JOptionPane.showConfirmDialog(m_registryModule.getAppDriver().getMainFrameWindow(),message,title,JOptionPane.YES_NO_OPTION);
                if (result==JOptionPane.YES_OPTION) {
                    m_registryModule.getAppDriver().startWaitState();
                    try {
                        StringBuffer messages=new StringBuffer();
                        while (iterator.hasNext()) {
                            OIModelInfo oimodelinfo=(OIModelInfo)iterator.next();
                            try {
                                oimodelinfo.delete();
                                oimodelinfo.commit();
                            }
                            catch (KAONException error) {
                                try {
                                    if (messages.length()==0)
                                        messages.append(m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.DeleteOIModelInfo.DeleteErrorMessage"));
                                    messages.append("\n");
                                    messages.append(oimodelinfo.getLogicalURI());
                                }
                                catch( KAONException silent) {
                                }
                            }
                        }
                        if (messages.length()>0)
                            JOptionPane.showMessageDialog(m_registryModule.getAppDriver().getMainFrameWindow(),messages.toString(),m_registryModule.getAppDriver().getLocalizationManager().getPhrase("registry.DeleteOIModelInfo.DeleteErrorTitle"),JOptionPane.ERROR_MESSAGE);
                        getViewable().doSearch();
                    }
                    finally {
                        m_registryModule.getAppDriver().endWaitState();
                    }
                }
            }
        }
        catch (Exception error) {
            m_registryModule.getAppDriver().displayErrorNotification(error);
        }
    }
    public void updateAction() {
        setEnabled(commandsAreEnabled() && getViewable().getCurrentOIModelInfos().hasNext());
    }
}
