package de.fzi.wim.registry.gui.actions;

import de.fzi.wim.guibase.actions.*;
import de.fzi.wim.guibase.appdriver.*;

import de.fzi.wim.registry.gui.*;
import de.fzi.wim.registry.gui.ui.*;

/**
 * Base class for all actions of the registry.
 */
public abstract class AbstractRegistryAction extends AbstractSmartAction {
    /** The registry module. */
    protected RegistryModule m_registryModule;

    /**
     * Creates an instance of this class.
     *
     * @param registryModule                    the registry module
     * @param actionID                          the ID of the action
     */
    public AbstractRegistryAction(RegistryModule registryModule,String actionID) {
        super(actionID,registryModule.getAppDriver().getLocalizationManager());
        m_registryModule=registryModule;
    }
    /**
     * Returns <code>true</code> if the commands are enabled for the current viewable.
     *
     * @return                                  <code>true</code> if commands are enabled for the current viewable
     */
    protected boolean commandsAreEnabled() {
        RegistryViewable viewable=getViewable();
        return viewable!=null && viewable.commandsAreEnabled();
    }
    /**
     * Returns the current viewable.
     *
     * @return                                  the current viewable, or <code>null</code> if a registry viewable is not currently active
     */
    protected RegistryViewable getViewable() {
        Viewable viewable=m_registryModule.getAppDriver().getSelectedViewable();
        if (viewable instanceof RegistryViewable)
            return (RegistryViewable)viewable;
        else
            return null;
    }
}
