package de.fzi.wim.registry.gui;

import de.fzi.wim.guibase.appdriver.*;
import de.fzi.wim.guibase.configuration.*;

import de.fzi.wim.registry.gui.actions.*;

/**
 * The module for the registry GUI.
 */
public class RegistryModule extends AbstractModule {
    /** The name of this module. */
    public static final String NAME="RegistryModule";

    /**
     * Returns the name of the localization resource that should be loaded for this module.
     *
     * @return                              the name of the localization resource
     */
    public String getLocalizationResourceName() {
        return "de/fzi/wim/registry/gui/res/registry.xml";
    }
    /**
     * Sets the application driver of the module.
     *
     * @param appDriver                     application driver
     */
    public void setAppDriver(AppDriver appDriver) {
        super.setAppDriver(appDriver);
        addAction(new OpenRegistry(this));
        addAction(new NewRegistry(this));
        addAction(new OpenOIModel(this));
        addAction(new SaveRegistry(this));
		addAction(new DeleteOIModelInfo(this));
		addAction(new RefreshSearch(this));
    }
    /**
     * Returns the name of the module.
     *
     * @return                              the name of this module
     */
    public String getModuleName() {
        return NAME;
    }
    /**
     * Called to restore the saved UI state of the viewable.
     *
     * @param configuration                 the configuration
     */
    public void restoreUIState(Configuration configuration) {
    }
}
