package de.fzi.wim.registry.api;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

/**
 * A Synonym of a term in the registry. This class just encapsulates the LexicalEntry class.
 */
public class Synonym extends AbstractRegistryEntity {
    /**
     * Creates an instance of this class.
     *
     * @param registry                  the registry
     * @param synonym                   the instance representing the term synonym
     */
    public Synonym(Registry registry,Instance synonym) {
        super(registry,synonym);
    }
    /**
     * Returns the URI of the type of this object.
     *
     * @return                                      the URI of the object type
     */
    protected String getTypeURI() {
        return KAONVocabularyAdaptor.INSTANCE.getSynonym();
    }
    /**
     * Returns the terms that this synonym references.
     *
     * @return                          the set of terms referenced by this synonym
     * @throws KAONException            thrown if there is a problem
     */
    public Set getReferencedTerms() throws KAONException {
        Set result=new HashSet();
        Property references=m_entity.getOIModel().getProperty(KAONVocabularyAdaptor.INSTANCE.getReferences());
        Iterator iterator=m_entity.getFromPropertyValues(references).iterator();
        while (iterator.hasNext()) {
            Instance instance=(Instance)iterator.next();
            result.add(m_registry.getTerm(instance.getURI()));
        }
        return result;
    }
    /**
     * Adds the reference to the term by this synonym.
     *
     * @param term                       the term
     * @throws KAONException             thrown if there is a problem
     */
    public void addReferencedTerm(Term term) throws KAONException {
        addPropertyValue(KAONVocabularyAdaptor.INSTANCE.getReferences(),m_entity,term.getEntity());
    }
    /**
     * Removes the reference to the term from this synonym.
     *
     * @param term                       the term
     * @throws KAONException             thrown if there is a problem
     */
    public void removeReferencedTerm(Term term) throws KAONException {
        removePropertyValue(KAONVocabularyAdaptor.INSTANCE.getReferences(),m_entity,term.getEntity());
    }
    /**
     * Returns the value of the synonym
     *
     * @return                          the value of the synonym
     * @throws KAONException            thrown if there is a problem
     */
    public String getValue() throws KAONException {
        return getLiteralPropertyValue(KAONVocabularyAdaptor.INSTANCE.getValue());
    }
    /**
     * Sets the value of this synonym.
     *
     * @param value                      the value of the synonym
     * @throws KAONException             thrown if there is a problem
     */
    public void setValue(String value) throws KAONException {
        setPropertyValue(KAONVocabularyAdaptor.INSTANCE.getValue(),m_entity,value);
    }
    /**
     * Returns the uri to the language of the synonym
     *
     * @return                          the uri to the language of the synonym
     * @throws KAONException            thrown if there is a problem
     */
    public String getLanguageURI() throws KAONException {
        return getLiteralPropertyValue(KAONVocabularyAdaptor.INSTANCE.getInLanguage());
    }
    /**
     * Sets the language of this synonym.
     *
     * @param languageURI                uri to the language to be set
     * @throws KAONException             thrown if there is a problem
     */
    public void setLanguageURI(String languageURI) throws KAONException {
       Instance language=m_registry.getRegistryOIModelInstance().getInstance(languageURI);
       if (language!=null)
           setPropertyValue(KAONVocabularyAdaptor.INSTANCE.getInLanguage(),m_entity,language);
    }
}
