package de.fzi.wim.registry.api;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Encapsulates information about a project in the registry.
 */
public class Project extends AbstractRegistryEntity {

    /**
     * Creates an instance of this class.
     *
     * @param registry                  the registry
     * @param project                   the instance representing the project
     */
    public Project(Registry registry,Instance project) {
        super(registry,project);
    }
    /**
     * Returns the URI of the type of this object.
     *
     * @return                                      the URI of the object type
     */
    protected String getTypeURI() {
        return OMO_Project;
    }
    /**
     * Returns the name of the project.
     *
     * @return                          the name of the project
     * @throws KAONException            thrown if there is a problem
     */
    public String getProjectName() throws KAONException {
        return getLiteralPropertyValue(OMO_projectName);
    }
    /**
     * Sets the name of the project.
     *
     * @param projectName               the name of the project
     * @throws KAONException            thrown if there is a problem
     */
    public void setProjectName(String projectName) throws KAONException {
        setPropertyValue(OMO_projectName,projectName);
    }
}
