package de.fzi.wim.registry.api;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Encapsulates information about a person in the registry.
 */
public class Person extends Party {

    /**
     * Creates an instance of this class.
     *
     * @param registry                  the registry
     * @param personInstance            the instance representing the person
     */
    public Person(Registry registry,Instance personInstance) {
        super(registry,personInstance);
    }
    /**
     * Returns the URI of the type of this object.
     *
     * @return                                      the URI of the object type
     */
    protected String getTypeURI() {
        return OMO_Person;
    }
    /**
     * Returns the name of the person.
     *
     * @return                          the name of the person
     * @throws KAONException            thrown if there is a problem
     */
    public String getPersonName() throws KAONException {
        return getLiteralPropertyValue(OMO_personName);
    }
    /**
     * Sets the name of the person.
     *
     * @param personName                the name of the person
     * @throws KAONException            thrown if there is a problem
     */
    public void setPersonName(String personName) throws KAONException {
        setPropertyValue(OMO_personName,personName);
    }
}
