package de.fzi.wim.registry.api;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Encapsulates information about a party in the registry.
 */
public abstract class Party extends AbstractRegistryEntity {

    /**
     * Creates an instance of this class.
     *
     * @param registry                  the registry
     * @param partyInstance             the instance representing the party
     */
    public Party(Registry registry,Instance partyInstance) {
        super(registry,partyInstance);
    }
    /**
     * Returns the URI of the type of this object.
     *
     * @return                                      the URI of the object type
     */
    protected String getTypeURI() {
        return OMO_Party;
    }
    /**
     * Returns the party's street and number.
     *
     * @return                          the party's address
     * @throws KAONException            thrown if there is a problem
     */
    public String getStreetAndNumber() throws KAONException {
        return getLiteralPropertyValue(OMO_streetAndNumber);
    }
    /**
     * Sets the party's street and number.
     *
     * @param streetAndNumber           the party's street and number
     * @throws KAONException            thrown if there is a problem
     */
    public void setStreetAndNumber(String streetAndNumber) throws KAONException {
        setPropertyValue(OMO_streetAndNumber,streetAndNumber);
    }
    /**
     * Returns the party's country.
     *
     * @return                          the party's country
     * @throws KAONException            thrown if there is a problem
     */
    public String getCountry() throws KAONException {
        return getLiteralPropertyValue(OMO_country);
    }
    /**
     * Sets the party's country.
     *
     * @param country                   the party's country
     * @throws KAONException            thrown if there is a problem
     */
    public void setCountry(String country) throws KAONException {
        setPropertyValue(OMO_country,country);
    }
    /**
     * Returns the party's state.
     *
     * @return                          the party's state
     * @throws KAONException            thrown if there is a problem
     */
    public String getState() throws KAONException {
        return getLiteralPropertyValue(OMO_state);
    }
    /**
     * Sets the party's state.
     *
     * @param state                     the party's state
     * @throws KAONException            thrown if there is a problem
     */
    public void setState(String state) throws KAONException {
        setPropertyValue(OMO_state,state);
    }
    /**
     * Returns the party's ZIP code.
     *
     * @return                          the party's ZIP code
     * @throws KAONException            thrown if there is a problem
     */
    public String getZIP() throws KAONException {
        return getLiteralPropertyValue(OMO_ZIP);
    }
    /**
     * Sets the party's ZIP code.
     *
     * @param zip                       the party's ZIP code
     * @throws KAONException            thrown if there is a problem
     */
    public void setZIP(String zip) throws KAONException {
        setPropertyValue(OMO_ZIP,zip);
    }
}
