package de.fzi.wim.registry.api;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Encapsulates information about an organization in the registry.
 */
public class Organization extends Party {

    /**
     * Creates an instance of this class.
     *
     * @param registry                  the registry
     * @param organizationInstance      the instance representing the organization
     */
    public Organization(Registry registry,Instance organizationInstance) {
        super(registry,organizationInstance);
    }
    /**
     * Returns the URI of the type of this object.
     *
     * @return                                      the URI of the object type
     */
    protected String getTypeURI() {
        return OMO_Organization;
    }
    /**
     * Returns the name of the organization.
     *
     * @return                          the name of the organization
     * @throws KAONException            thrown if there is a problem
     */
    public String getOrganizationName() throws KAONException {
        return getLiteralPropertyValue(OMO_organizationName);
    }
    /**
     * Sets the name of the organization.
     *
     * @param organizationName          the name of the organization
     * @throws KAONException            thrown if there is a problem
     */
    public void setOrganizationName(String organizationName) throws KAONException {
        setPropertyValue(OMO_organizationName,organizationName);
    }
}
