package de.fzi.wim.registry.api;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Encapsulates information about an application field in the registry.
 */
public class ApplicationField extends AbstractRegistryEntity {

    /**
     * Creates an instance of this class.
     *
     * @param registry                  the registry
     * @param applicationFieldInstance  the instance representing the application field
     */
    public ApplicationField(Registry registry,Instance applicationFieldInstance) {
        super(registry,applicationFieldInstance);
    }
    /**
     * Returns the URI of the type of this object.
     *
     * @return                                      the URI of the object type
     */
    protected String getTypeURI() {
        return OMO_ApplicationField;
    }
    /**
     * Returns the name of the application field.
     *
     * @return                          the name of the application field
     * @throws KAONException            thrown if there is a problem
     */
    public String getApplicationFieldName() throws KAONException {
        return getLiteralPropertyValue(OMO_applicationFieldName);
    }
    /**
     * Sets the name of the application field.
     *
     * @param applicationFieldName      the name of the application field
     * @throws KAONException            thrown if there is a problem
     */
    public void setApplicationFieldName(String applicationFieldName) throws KAONException {
        setPropertyValue(OMO_applicationFieldName,applicationFieldName);
    }
}
