package edu.unika.aifb.rdf.rdfserver.interfaces;

import java.io.Serializable;

/**
 * Encapsulates statement information.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class StatementInfo implements Serializable {
    protected Integer m_statementID;
    protected String m_modelID;
    protected String m_subject;
    protected String m_predicate;
    protected String m_object;
    protected boolean m_objectIsLiteral;
    protected int m_statementAction;

    public StatementInfo(Integer statementID,String modelID,String subject,String predicate,String object,boolean objectIsLiteral) {
        m_statementID=statementID;
        m_modelID=modelID;
        m_subject=subject;
        m_predicate=predicate;
        m_object=object;
        m_objectIsLiteral=objectIsLiteral;
    }
    public StatementInfo(Integer statementID,String modelID,String subject,String predicate,String object,boolean objectIsLiteral,int statementAction) {
        this(statementID,modelID,subject,predicate,object,objectIsLiteral);
        m_statementAction=statementAction;
    }
    public String getModelID() {
        return m_modelID;
    }
    public Integer getStatementID() {
        return m_statementID;
    }
    public String getSubject() {
        return m_subject;
    }
    public String getPredicate() {
        return m_predicate;
    }
    public String getObject() {
        return m_object;
    }
    public boolean getObjectIsLiteral() {
        return m_objectIsLiteral;
    }
    public int getStatementAction() {
        return m_statementAction;
    }
}
