package edu.unika.aifb.rdf.rdfserver.interfaces;

import java.util.Hashtable;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * Encapsulates a connection to the server and provides some commonly used methods for manipulation of beans.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public class RemoteConnection {
    protected Context m_context;
    protected ModelHome m_modelHome;

    /**
     * Opens connection to the application server as specified in jndi.properties file.
     */
    public RemoteConnection() throws NamingException {
        m_context = new InitialContext();
        initialize();
    }

    /**
     * Opens a connection to the application server as specified in the given hashtable.
     */
    public RemoteConnection(Hashtable jndiProperties) throws NamingException {
        m_context = new InitialContext(jndiProperties);
        initialize();
    }

    /**
     * Opens a connection to the application server to JBoss at given address.
     *
     * @param hostName          name of JBoss host
     * @param portNumber        number of JBoss port
     */
    public RemoteConnection(String hostName, int portNumber) throws NamingException {
        Hashtable jndiProperties = new Hashtable();
        jndiProperties.put("java.naming.factory.initial","org.jnp.interfaces.NamingContextFactory");
        jndiProperties.put("java.naming.provider.url","jnp://" + hostName + ":" + portNumber);
        jndiProperties.put("java.naming.factory.url.pkgs","org.jboss.naming:org.jnp.interfaces");
        m_context = new InitialContext(jndiProperties);
        initialize();
    }

    /**
     * Initializes the state of this class.
     */
    protected void initialize() throws NamingException {
        Object objRef = m_context.lookup(ModelHome.JNDI_NAME);
        m_modelHome = (ModelHome) PortableRemoteObject.narrow(objRef, ModelHome.class);
    }

    public Context getContext() {
        return m_context;
    }

    public ModelHome getModelHome() {
        return m_modelHome;
    }

    public Model createModel(String alias) throws RemoteException, CreateException {
        return m_modelHome.create(alias);
    }

    public Model loadModel(String alias) throws RemoteException, FinderException {
        return m_modelHome.findByPrimaryKey(alias);
    }
}
