package edu.unika.aifb.rdf.rdfserver.interfaces;

import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;
import java.util.Hashtable;

public class ModelUtil
{
   // Home interface lookup methods

   /**
    * Obtain remote home interface from default initial context
    * @return Home interface for Model. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome getHome() throws NamingException
   {
      InitialContext initialContext = new InitialContext();
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome.JNDI_NAME);
         edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome home = (edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

   /**
    * Obtain remote home interface from parameterised initial context
    * @param environment Parameters to use for creating initial context
    * @return Home interface for Model. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome getHome( Hashtable environment ) throws NamingException
   {
      InitialContext initialContext = new InitialContext(environment);
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome.JNDI_NAME);
         edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome home = (edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

}
