package edu.unika.aifb.rdf.rdfserver.interfaces;

import javax.rmi.PortableRemoteObject;
import javax.naming.NamingException;
import javax.naming.InitialContext;
import java.util.Hashtable;

/**
 * Utility class for Literal.
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)

 * @author Boris Motik (boris.motik@fzi.de)
 * @xdoclet-generated at 13.08.2004 11:27:21
 */
public class LiteralUtil
{
   // Home interface lookup methods

   /**
    * Obtain remote home interface from default initial context
    * @return Home interface for Literal. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome getHome() throws NamingException
   {
      InitialContext initialContext = new InitialContext();
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome.JNDI_NAME);
         edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome home = (edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

   /**
    * Obtain remote home interface from parameterised initial context
    * @param environment Parameters to use for creating initial context
    * @return Home interface for Literal. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome getHome( Hashtable environment ) throws NamingException
   {
      InitialContext initialContext = new InitialContext(environment);
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome.JNDI_NAME);
         edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome home = (edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

}
